;
;DIALING ROUTINES TAKEN (AND GREATLY MODIFIED) FROM PMMI MANUAL.
;MODEM CONTROL COMMAND WORDS

CLEAR	EQU 3FH	;IDLE MODE
MAKEM	EQU 1	;TELE LINE MAKE (OFF HOOK)
BRKM	EQU 0	;TELE LINE ON HOOK (BREAK DURING DIALING)
DTMSK	EQU 1	;DIAL TONE MASK
RBLMT	EQU 70	;# OF SEC*10 TO WAIT BEFORE GIVING NO RING HEARG MSG
RBWAIT	EQU 50	;# OF SEC*10 DELAY BEFORE REDIALING NUMBER
TMPUL	EQU 80H	;TIMER PULSES MASK BIT
;
DFLTMD	EQU 0	;0=PULSE DIAL, ELSE MF
ONTIM	EQU 7	;TONE ON TIME (10 MS UNITS)
OFTIM	EQU 7	;TONE OFF TIME
MFPORT	EQU 0D8H	;8255 PORT A
MFCTL	EQU 0DBH	;8255 CTRL
DYCON	EQU 0300H	;FOR 10 MS DELAY @ 4MHZ
;
NUMINS	EQU	'^'	;INSERT USER NR HERE
GOMF	EQU	'%'	; GOTO M.F. MODE NOW
WTDLTN	EQU	','	;WAIT FOR DIAL TONE
;
DIALPL:	LDA	PMMIBYTE ;FLAG FOR PMMI OPERATION
	ORA	A	;SET FLAGS
	RZ		;PMMI FALSE, RETURN
	MVI	A,80H
	OUT	MFCTL	;8255 CTRL SETUP
	XRA	A	; 0
	STA	CRFLAG	;CONTINUOUS REDIAL FLAG
	STA	RBFLG	;RINGBACK NOT WANTED INIT
	CALL	DIALPL0	; DISCONNECT, RECONNECT, WAIT DIAL TONE
	JC	DILAGN	;ASK IF TRY AGAIN
	LXI	H,CMDBUF+1 ;POINT # OF CHARS IN BUFF
	MOV	A,M	;GET # OF CHARS
	CPI	4	;4 OR MORE CHARS TYPED BEFORE <CR>?
	JC	ENTNUM	;NO, ASK FOR NUMBER
	LXI	H,CMDBUF+6 ;POINT TO NUMBER TO DIAL
	JMP	DIAL10	;CHECK IF LIB #, & DIAL

DIALPL0:
	CALL	DISCONNT
	CALL	ILPRT
DB	CR,LF,'Waiting for dial tone',CR,LF,0

	MVI	A,MAKEM	;MAKE MAKE (OFF-HOOK)
	CALL	OUT$MODCTLP ;DO IT
	MVI	A,CLEAR OR 80H
	CALL	OUT$MODCTL2
DTW:	MVI	D,DTMSK	;DIAL TONE MASK
	MVI	C,200	;20 SECOND WAIT
	CALL	WAIT	;WAIT FOR DIAL TONE
	NOP		;DELAY

; WAIT SUBROUTINE WILL RETURN WITH CARRY SET IF UNABLE TO
; GET DIALTONE, ELSE CARRY NOT SET MEANS DIALTONE RECEIVED

	RNC		;IF DIAL TONE WITHIN 20 SECONDS
	CALL	ILPRT	;ELSE, MESSAGE AND RETURN WITH CARRY SET
DB	CR,LF
DB	'++No dial tone after 20 seconds++',CR,LF,0
	STC
	RET

ENTNUM:	;this is all the set-up for the print at entnum2.
	MVI	C,13	;number of lines to move
	LXI	H,NUMBLIB ;address of source memory
	LXI	D,DBUF	;address of target memory
	CALL	NEWLINE	;start with CRLF
	STAX	D	;+LF
	INX	D	;and bump it

ENTNUM1:
	MVI	B,32	;number of bytes to move
	CALL	MOVE	;move to buffer
	CALL	SPACES	;2 entries + 3 spaces = 67 characters
	MVI	B,32
	CALL	MOVE
	CALL	NEWLINE
	DCR	C	;number of lines to print
	JZ	ENTNUM2
	JMP	ENTNUM1


ENTNUM2:
	MVI	A,'$'
	STAX	D
	MVI	C,PRINT
	LXI	D,DBUF	;point to table of numbers to print
	CALL	BDOS
	CALL	CRLF

	CALL	ILPRT
DB	'Enter number or library letter - Type C/R when finished,',CR,LF
DB	'CTRL-X cancels while dialing:        ',0

	LXI	D,CMDBUF
	CALL	INBUFF

DIALLP1:
	LDA	CMDBUF+1
	ORA	A	;NULL MEANS <CR> WAS TYPED
	JZ	BORTIT	;ABORT DIALING, RETURN TO MENU

	LXI	H,CMDBUF+2 ;FIRST TYPED CHAR OF NUMBER TO DIAL
 ;
 ; ENTER THIS ROUTINE WITH HL POINTING TO NUMBER TO DIAL
 ;
DIAL10:
	MVI	B,'A'	;FIRST LETTER OF ALPHABET
	MVI	E,0	;COUNTS NUMBER OF LETTERS TO MATCH
	MVI	C,26	;NUMBER OF LETTERS IN ALPHABET
	MOV	A,M	;GET CHAR BUFFER
DIAL11:
	CMP	B	;NUMBER FROM TABLE?
	JZ	LIBSET
	INR	B	;MAKE NEXT LETTER (A-Z)
	INR	E	;COUNT UP
	DCR	C	;COUNT DOWN
	JZ	DIALLPX	;NOT A LETTER
	JMP	DIAL11	;LOOP

LIBSET:
	LXI	H,NUMBLIB ;PHONE NUMBER LIBRARY
	LXI	B,32	;LENGTH OF LIBRARY ENTRY
	MOV	A,E	;NUMBER OF TIMES TO ADD 32 TO HL
	ORA	A	;SET FLAGS
	JZ	DIAL13

DIAL12:
	MOV	A,M	;GET FIRST CHAR OF SELECTED LIB ENTRY
	ORA	A	;SET FLAGS
	JZ	DIALLP2	;SEND BADLIB MSG
	DAD	B	;INCREMENT HL BY 30
	DCR	E	;COUNTDOWN
	JNZ	DIAL12	;NOT THERE YET, LOOP

DIAL13:
	MVI	B,32	;NUMBER OF CHARACTERS TO GET FROM TABLE
	LXI	D,CMDBUF+1 ;POINT TO BUFFER
	XCHG		;HL POINTS TO CMDBUF+1
	MOV	M,B	;STORE # OF BYTES IN A TABLE ENTRY
	XCHG		;RESTORE REG.
	INX	D	;POINT TO FIRST CHAR POSITION IN BUFFER
	CALL	MOVE	;MOVE TABLE ENTRY TO BUFFER

DIALLPX:
	LDA	CMDBUF+1
	MOV	E,A	;NUMBER OF CHARS IN BUFF
	LXI	H,CMDBUF+2 ;POINT FIRST CHAR
;
DILP2A:	XRA	A
	STA	INSACT
	MVI	A,DFLTMD ;PULSE OR MF DEFAULT
	STA	MFMODE
DIALLP2:
	MOV	A,M	;GET FIRST # FROM BUFFER
	INX	H	;BUMP POINTER NOW
 ;
 ; ROUTINE TO PRINT 'BADLIB' MESSAGE AND ABORT IF NULL ENCOUNTERED
 ;
	ORA	A	;SET FLAGS
	PUSH	D	;SAVE DE REGISTERS
	LXI	D,BADLIB ;BAD LIBRARY NUMBER IF NULL
	MVI	C,PRINT	; 9
	PUSH	PSW	;SAVE A AND FLAGS
	CZ	BDOS
	POP	PSW	;RESTORE A AND FLAGS
	POP	D	;RESTORE DE REGISTERS
	JZ	BORTIT	;ABORT
;
; DIAL A DIGIT, CHECK KBD FOR ABORT
;
	CALL	DIAL	;DIAL IT
	CALL	STAT	; KEYPRESS?
	ORA	A	;SET FLAGS
	CNZ	KEYIN	;YES, GO GET IT
	CPI	CAN	; ^X?
	JZ	BORTIT	;YES, ABORT
	PUSH	D	;SAVE DE
	PUSH	H	;SAVE HL
	MVI	B,1	;WAIT 1 TIME INTERVAL
	CALL	TIMER
	POP	H	;RESTORE HL
	POP	D	;RESTORE DE
	DCR	E	;COUNT DOWN CHARS IN BUFF
	JNZ	DIALLP2	;NOT DONE, LOOP
	LDA	INSACT
	ORA	A
	JNZ	INSEND
	LDA	RBFLG
	ORA	A
	JZ	DIALDN	;DIALING DONE
	JMP	RINGBK
;
BADLIB:	DB	CR,LF,'++Bad library number called++',CR,LF,'$'
;
INSEND:	XRA	A
	STA	INSACT
	LHLD	CANHSV
	LDA	CANESV
	MOV	E,A
	JMP	DIALLP2
;
DISCONNT:
	XRA	A	;0
	CALL	OUT$MODCTL2 ;CLEAR DAV, ESD, ETC
	CALL	OUT$MODCTLP ;HANG-UP
	PUSH	B
	MVI	B,8	;wait for PMMI to disconnect
	CALL	TIMER
	POP	B
	RET

TIMER:	LDA	PULSERATE	;TRATE 250, VALUE FOR .1 SEC INTERVAL
	CALL	OUT$BAUDRP ;B-REG CONTAINS NUMBER OF .1 SEC INTERVALS
TIMES:	CALL	IN$BAUDRP  ;TO COUNT
	ANI	TMPUL
	JZ	TIMES	;WAIT FOR TIMER TO GO HIGH
TIMEE:	CALL	IN$BAUDRP
	ANI	TMPUL
	JNZ	TIMEE	;WAIT FOR TIMER TO GO LOW
	DCR	B
	JNZ	TIMES
	RET

BORTIT:	CALL DISCONNT
	JMP	MENU

;AUTO DIALER

DIAL:	CALL	TYPE	;PRINT WHATEVER CHARACTER, DASHES, ETC.
	CPI	'@'	;CANNED NUMBER?
	JZ	CANST1
	CPI	'#'
	JZ	CANST2
	CPI	NUMINS	;NUMBER INSERT?
	JZ	NINSRT
	CPI	GOMF	;GO TO MF MODE?
	JZ	MFSET
	CPI	WTDLTN	;WAIT 2ND DIAL TONE?
	JZ	DTWAIT
	CPI	'0'
	RC		;DIGIT MUST BE AT LEAST 0..
	CPI	'R'	;COULD IT BE A RINGBACK CHARACTER
	JNZ	DIAL1	;NO? - JUMP
	PUSH	PSW	;SAVE ACCUMULATOR & FLAGS
	MOV	A,E	;GET # OF CHAR LEFT INTO ACC.
	CPI	01H	;IS THIS THE LAST CHARACTER?
	JZ	RBSET	;IF SO, IT MUST BE RINGBACK CHAR - DO RINGBACK
	POP	PSW	;EVERYTHING BACK AS IT WAS
DIAL1:	MOV	C,A	;SAVE THE CHAR
	LDA	MFMODE
	ORA	A	;IN EFFECT?
	MOV	A,C
	JNZ	MFDIG	;YES
	CPI	'9'+1
	RNC		;..AND NOT MORE THAN 9
	ANI	0FH	;STRIP ASCII -- COULD ALSO DO SUI 30H ('0')
	JNZ	DIALS
	MVI	A,10	;CONVERT ZERO TO 10 PULSES
DIALS:	MOV	C,A
	LDA	PULSERATE ;CONTAINS VALUE FOR DIAL SPEED
	CALL	OUT$BAUDRP
DIALC:	CALL	IN$BAUDRP
	ANI	TMPUL
	JNZ	DIALC
DIALB:	CALL	IN$BAUDRP
	ANI	TMPUL
	JZ	DIALB
MAKEP:	MVI	A,MAKEM
	CALL	OUT$MODCTLP
TIMEM:	CALL	IN$BAUDRP
	ANI	TMPUL
	JNZ	TIMEM
	MVI	A,BRKM
	CALL	OUT$MODCTLP
TIMEB:	CALL	IN$BAUDRP
	ANI	TMPUL
	JZ	TIMEB
	DCR	C
	JNZ	MAKEP
	MVI	A,MAKEM
	CALL	OUT$MODCTLP
	MVI	B,2
	CALL	TIMER
	RET
;
CANST1:	SHLD	NUMHSV	;PTR TO NUMBER
	MOV	A,E
	STA	NUMESV	;COUNT LEFT
	LXI	H,CANLN1
CNRCOM:	MOV	E,M
	INX	H
	RET
;
CANST2:	SHLD	NUMHSV
	MOV	A,E
	STA	NUMESV
	LXI	H,CANLN2
	JMP	CNRCOM
;
NINSRT:	SHLD	CANHSV	;PTR TO CANNED NUMBER
	MOV	A,E
	STA	CANESV	;CANNED COUNT LEFT
	STA	INSACT	;MARK INSERT ACTIVE
	LHLD	NUMHSV	;RESTORE NUMBER PTR
	LDA	NUMESV
	MOV	E,A	;RESTORE COUNT
	RET
;
MFSET:	MVI	A,0FFH
	STA	MFMODE
	RET
;
RBSET:	POP	PSW	;ADJUST STACK
	MVI	A,0FFH
	STA	RBFLG	;WANT RINGBACK
	RET
;
DTWAIT:	CALL	DTW	;DIAL TONE TEST
	RNC		;GOT IT
	POP	PSW	;RETN OFF STACK
	JMP	DILAGN
;
;	MULTI-FREQ. CALLING ROUTINE
;
MFDIG:	PUSH	H
	LXI	H,MFTBL
	SUI	'0'	;ASCII TO COUNT
	ADD	L
	MOV	L,A
	JNC	NOCY
	INR	H
NOCY:	MOV	A,M
	CMA
	OUT	MFPORT
	MVI	B,ONTIM
	CALL	MFDLY
	MVI	A,0FFH
	OUT	MFPORT
	MVI	B,OFTIM
	CALL	MFDLY
	POP	H
	RET
;
MFDLY:	LXI	H,DYCON
	INR	H
DYLP:	XTHL
	XTHL
	DCR	L
	JNZ	DYLP
	DCR	H
	JNZ	DYLP
	DCR	B
	JNZ	MFDLY
	RET
;
RINGBK:	LDA	CMDBUF+1 ;GET # OF CHAR IN BUFFER
	SUI	01	;SUBTRACT 1 TO AVOID THE RINGBACK CHAR
	STA	CMDBUF+1 ;STORE THE NEW VALUE
	MVI	D,DTMSK	;LOAD TONE DETECT MASK
	MVI	C,RBLMT	;SET TIMER FOR RBLMT NUMBER OF SECONDS
	CALL	WAIT
	JC	RBTIME	;JUMP IF NO RING DETECTED
	MVI	B,25	;WAIT 2.5 SEC
	CALL	TIMER
	CALL	IN$BAUDRP ;IS TONE STILL PRESENT?
	ANA	D
	JNZ	RNGBK1
	JMP	DILAGN	;YES, MUST BE BUSY

RNGBK1:	CALL	HANGP	;HANG UP THE PHONE
	MVI	B,RBWAIT ;WAIT X SEC
	CALL	TIMER
	CALL	DIALPL0	;GO OFF HOOK & LISTEN FOR DIAL TONE
	JNC	DIALLPX	;GO REDIAL NUMBER
	JMP	DILAGN	;NO DIAL TONE HEARD

RBTIME:	CALL	CRLF
	JMP	RNGBK1	;HANGUP, REDIAL, & LISTEN FOR CARRIER


;TIME OUT ROUTINE. MUST BE CALLED WITH MASK IN D REG FOR INPUT
;AT RELATIVE PORT 2 AND NUMBER OF SECONDS * 10 IN C REG.

WAIT:	MVI	B,1	
	CALL	TIMER	;WAIT FOR TIMER TO GO HIGH THEN LOW
	CALL	IN$BAUDRP ;PMMIADDR+2 (MODEM STATUS PORT)
	ANA	D	;(CTS or DIALTONE MASK)
	RZ		;ACTIVE LOW, SO RETURN ON 0
	PUSH	B	;SAVE..
	PUSH	D	;..ACTIVE REG'S
	CALL	STAT	;KEYPRESS?
	ORA	A	;SET FLAGS
	CNZ	KEYIN	;YES, GET CHAR
	POP D		;RESTORE..
	POP B		;..REGS
	CPI	CAN	;^X?
	JZ	DISCON1	;YES, DISCONNECT, JMP TO MENU
	ANI	5FH	;ANY CASE OK
	CPI	'C'
	JZ	WAIT1
	DCR C		;COUNT-DOWN
	JNZ	WAIT
	STC		;SET CARRY TO INDICATE MASK NOT SET
	RET
;
WAIT1:	ORA	A	;ACCEPT
	RET
;
HANGP:	MVI	A,CLEAR
	CALL	OUT$MODCTL2
	MVI	A,0
	CALL	OUT$MODCTLP
	RET

DIALDN:	CALL	CRLF
	MVI	A,0FFH	    ;TURN ON DTR
	CALL	OUT$MODCTL2 ;TIMER RATE?

	MVI	B,1
	CALL	TIMER	;WAIT FOR MODEM TO TURN ON DTR

	MVI	A,5DH	;2 STOP BITS, NO PARITY, 8 DATA BITS
			;+ NO DISCONNECT AFTER 17 SECS
	CALL	OUT$MODCTLP

	MVI	D,4	  ;CLEAR TO SEND MASK
	MVI	C,WAITCTS ;wait time for cts (25.5 SEC MAX)
	CALL	WAIT
	JNC	GOTCTS	;GOT RESPONSE
	MVI	C,100	;10 MORE SECS
	CALL	WAIT	;GIVE A BIT MORE

GOTCTS:	MVI	A,07FH	;KILL MONITOR
	CALL	OUT$MODCTL2
	JNC	CONMADE	;CONNECTION MADE

	CALL	DISCONNT
DILAGN:
	LDA	CRFLAG	;CONTINUOUS REDIAL FLAG
	ORA	A
	JNZ	DILAGN0
	CALL	ILPRT
DB	CR,LF,'No answer after time-out.  Redial? (Y/N/C): ',BELL,0
	CALL	KEYIN	;GET RESPONSE
	CALL	TYPE	;ECHO IT
	CALL	UCASE	;ANI 5FH
	CALL	CRLF	;NEW LINE
	CPI	'N'	;REDIAL?
	JZ	MENU	;NO, GO MENU
	CPI	'Y'	;REDIAL?
	JZ	DILAGN0	;YES, REDIAL
	CPI	'C'	;CONTINUOUS REDIAL?
	JNZ	DILAGN	;INVALID RESPONSE, ASK AGAIN
	XRA A ! CMA	;0FFH
	STA	CRFLAG	;CONTINUOUS REDIAL FLAG
 DILAGN0:
	MVI	B,50	;5 seconds wait for pmmi reset
	CALL	TIMER	;else busy tone may be sensed as dialtone
	CALL	DIALPL0	;WAIT FOR DIAL TONE
	JNC	DIALLP1	;DIAL NUMBER
	JMP	DILAGN	;NO DIAL TONE AFTER 10 SECS

CONMADE:
	CALL	ILPRT
DB	CR,LF,'Connection established - Select options: ',BELL,0
DILAGN1:
	CALL	STAT	;KEYPRESS?
	ORA	A	;SET FLAGS
	JNZ	GETCMD	;KEY PRESSED, GO GET OPTIONS
	MVI	A,BELL
	CALL	TYPE	;RING BELL
	LXI	B,2000H
DILAGN2:		;@7.32.........
	DCR	C
	JNZ	DILAGN2	;KILL SOME TIME FOR TERMINAL TO PROCESS BELL
	DCR	B
	JNZ	DILAGN2	;@7.32.........
	JMP	DILAGN1	;LOOP
;
INSACT:	DB	0	;INSERT ACTIVE
MFMODE:	DB	DFLTMD
CANHSV:	DS	2
CANESV:	DS	1
NUMHSV:	DS	2
NUMESV:	DS	1
RBFLG:	DB	0	;RINGBACK FLAG
CRFLAG:	DB	0	; CONTIN REDIAL FLAG
;
MFTBL:	DB	82H,11H,12H,14H	;0,1,2,3
	DB	21H,22H,24H,41H	;4,5,6,7
	DB	42H,44H,81H,84H	;8,9,*,#
	DB	18H,28H,48H,88H	;A,B,C,D
	DB	71H,72H,74H,78H	;C1,C2,C3,C4
	DB	17H,27H,47H,87H	;R1,R2,R3,R4
;
; END OF PMMI ROUTINES
;
;
;THE NON PMMI SETUP ROUTINES ARE INTENDED TO COME FROM
;THE USER OVERLAY. THE FOLLOWING IS A SAFETY NET
;
SETUPR:		RET
;
; PHONE NUMBER LIBRARY TABLE FOR DIALING FROM LIBRARY
; OF NUMBERS STORED IN THESE DB'S AT ASSEMBLY-TIME.
; EACH DB MUST BE 32 CHARACTERS LONG FOR PROPER OPERATION.
; A 'DB 0' INDICATES NO DIALING, PROGRAM WILL DISCONNECT
; AND RETURN TO COMMAND MODE.  LAST DB MUST BE DB 0. UP TO
; 26 NUMBERS ARE ALLOWED.
;
NUMBLIB:
;	'----5---10---15---20---25-----32'
DB	'A=Amrad           1-703-734-1387'	;'A'
DB	'B=                              '	;'B'
DB	'C=Cnode St.Coll.  1-814-238-4857'	;'C'
DB	'D=C.Cliff C.C.     @312-234-9257'	;'D'
DB	'E=Ron Fowler      @313-729-1905R'	;'E'
DB	'F=Chuck Forsberg  1-503-621-3193'	;'F'
DB	'G=Gasnet NASA      @301-344-9156'	;'G'
DB	'H=Dave Hardy       @313-846-6127'	;'H'
DB	'I=Wayne Hammerly   @301-953-3753'	;'I'
DB	'J=Sigi Kluger      @915-598-1668'	;'J'
DB	'K=David Kozinn    1-216-334-4604'	;'K'
DB	'L=Program Store   1-202-337-4694'	;'L'
DB	'M=Kelly Smith     1-805-527-9321'	;'M'
DB	'N=Ken Stritzel     @201-584-9227'	;'N'
DB	'O=SYSOP Sys        @313-885-0506'	;'O'
DB	'P=K.Petersen      @313-759-6569R'	;'P'
DB	'Q=R.Plouffe       1-303-524-2549'	;'Q'
DB	'R=Bruce Ratoff     @201-272-1874'	;'R'
DB	'S=ACGNJ ABBS       @201-968-1074'	;'S'
DB	'T=Tech. CBBS       @313-846-6127'	;'T'
DB	'U=PMMI            1-703-379-0303'	;'U'
DB	'V=Toronto I       1-416-231-9538'	;'V'
DB	'W=Toronto II      1-416-231-1262'	;'W'
DB	'X=                              '	;'X'
DB	'Y=                              '	;'Y'
DB	'Z=                              '	;'Z'
DB	0					; end
;
;	W. EARNEST NUMBER	@  as of 12/20/82
CANLN1:	DB	CANM1E-CANNM1 ;CANNED NUMBER LENGTH
CANNM1:	DB	'4342915,%xxxxxxxx^yy'
CANM1E	EQU	$
;	T. EARNEST NUMBER	#  as of 12/20/82
CANLN2:	DB	CANM2E-CANNM2 ;NUMBER LENGTH
CANNM2:	DB	'4342915,%xxxxxxxx^yy'
CANM2E	EQU	$
;
